/*
 * Decompiled with CFR 0.152.
 */
package io.github.hw9636.autosmithingtable.common;

import io.github.hw9636.autosmithingtable.common.Registries;
import io.github.hw9636.autosmithingtable.common.config.ASTConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.UpgradeRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoSmithingTableBlockEntity
extends BlockEntity
implements IEnergyStorage {
    public static final int SIDE_NONE = 0;
    public static final int SIDE_INPUT1 = 1;
    public static final int SIDE_INPUT2 = 2;
    public static final int SIDE_OUTPUT = 3;
    public final ItemStackHandler baseSlots = this.createInventory();
    public final ItemStackHandler additionSlots = this.createInventory();
    public final ItemStackHandler outputSlots = this.createOutputInventory();
    public final ContainerData data;
    private final LazyOptional<ItemStackHandler> baseSlotsLazy = LazyOptional.of(() -> this.baseSlots);
    private final LazyOptional<ItemStackHandler> additionSlotsLazy = LazyOptional.of(() -> this.additionSlots);
    private final LazyOptional<ItemStackHandler> outputSlotsLazy = LazyOptional.of(() -> this.outputSlots);
    private int FEStored = 0;
    private int progress = 0;
    private boolean requiresUpdate = false;
    private boolean canInsertOutput = false;
    private boolean checkRecipe = false;
    private UpgradeRecipe currentRecipe = null;
    private int sidesConfig;

    public AutoSmithingTableBlockEntity(BlockPos pos, BlockState blockstate) {
        super((BlockEntityType)Registries.AUTO_SMITHING_TABLE_ENTITY_TYPE.get(), pos, blockstate);
        this.data = this.getData();
        this.sidesConfig = this.getDefaultSidesConfig();
    }

    private int getDefaultSidesConfig() {
        return 1962;
    }

    public static int getSide(int sidesConfig, Direction side) {
        return switch (side) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> sidesConfig >> 10 & 3;
            case Direction.DOWN -> sidesConfig >> 8 & 3;
            case Direction.NORTH -> sidesConfig >> 6 & 3;
            case Direction.EAST -> sidesConfig >> 4 & 3;
            case Direction.SOUTH -> sidesConfig >> 2 & 3;
            case Direction.WEST -> sidesConfig & 3;
        };
    }

    private int getSide(Direction side) {
        return AutoSmithingTableBlockEntity.getSide(this.sidesConfig, side);
    }

    private boolean canInsert(ItemStack beforeInsert, ItemStack toInsert) {
        return beforeInsert.m_41619_() || beforeInsert.m_150930_(toInsert.m_41720_()) && beforeInsert.m_41613_() + toInsert.m_41613_() <= beforeInsert.m_41741_();
    }

    public void serverTick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (this.checkRecipe) {
            this.currentRecipe = this.getRecipeFromStacks(this.getItemInSlot(this.baseSlotsLazy, 0), this.getItemInSlot(this.additionSlotsLazy, 0));
            this.checkRecipe = false;
        }
        if (this.currentRecipe != null && this.canInsert(this.getItemInSlot(this.outputSlotsLazy, 0), this.currentRecipe.m_8043_())) {
            if (this.FEStored >= (Integer)ASTConfig.COMMON.energyPerTick.get()) {
                this.FEStored -= ((Integer)ASTConfig.COMMON.energyPerTick.get()).intValue();
                if (++this.progress == (Integer)ASTConfig.COMMON.ticksPerCraft.get()) {
                    this.progress = 0;
                    ItemStack result = this.currentRecipe.m_8043_().m_41777_();
                    result.m_41721_(this.getItemInSlot(this.baseSlotsLazy, 0).m_41773_());
                    if (this.insertItem(this.outputSlotsLazy, 0, result).m_41619_()) {
                        this.getItemInSlot(this.baseSlotsLazy, 0).m_41774_(1);
                        this.getItemInSlot(this.additionSlotsLazy, 0).m_41774_(1);
                        this.currentRecipe = this.getRecipeFromStacks(this.getItemInSlot(this.baseSlotsLazy, 0), this.getItemInSlot(this.additionSlotsLazy, 0));
                    }
                }
            } else if (this.progress > 0) {
                --this.progress;
            }
        }
        if (this.requiresUpdate) {
            this.requiresUpdate = false;
            this.update();
        }
    }

    private UpgradeRecipe getRecipeFromStacks(ItemStack input1, ItemStack input2) {
        return this.f_58857_ == null ? null : (UpgradeRecipe)this.f_58857_.m_7465_().m_44015_(RecipeType.f_44113_, (Container)new SimpleContainer(new ItemStack[]{input1, input2}), this.f_58857_).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction dir) {
        if (dir == null) {
            return LazyOptional.empty();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return switch (this.getSide(dir)) {
                case 1 -> this.baseSlotsLazy.cast();
                case 2 -> this.additionSlotsLazy.cast();
                case 3 -> this.outputSlotsLazy.cast();
                default -> LazyOptional.empty();
            };
        }
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of(() -> this).cast();
        }
        return super.getCapability(cap, dir);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.baseSlotsLazy.invalidate();
        LazyOptional.of(() -> this).invalidate();
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("InventoryBase", (Tag)this.baseSlots.serializeNBT());
        tag.m_128365_("InventoryAddition", (Tag)this.additionSlots.serializeNBT());
        tag.m_128365_("InventoryOutput", (Tag)this.outputSlots.serializeNBT());
        tag.m_128405_("Sides", this.sidesConfig);
        tag.m_128405_("FEStored", this.FEStored);
        tag.m_128405_("Progress", this.progress);
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.serializeNBT();
    }

    public void handleUpdateTag(CompoundTag tag) {
        super.handleUpdateTag(tag);
        this.m_142466_(tag);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.handleUpdateTag(pkt.m_131708_());
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.FEStored = tag.m_128451_("FEStored");
        this.progress = tag.m_128451_("Progress");
        this.baseSlots.deserializeNBT(tag.m_128469_("InventoryBase"));
        this.additionSlots.deserializeNBT(tag.m_128469_("InventoryAddition"));
        this.outputSlots.deserializeNBT(tag.m_128469_("InventoryOutput"));
        this.sidesConfig = tag.m_128451_("Sides");
        this.checkRecipe = true;
    }

    public static int setSide(Direction dir, int value, int sidesConfig) {
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> sidesConfig & 0x3FF | value << 10;
            case Direction.DOWN -> sidesConfig & 0xCFF | value << 8;
            case Direction.NORTH -> sidesConfig & 0xF3F | value << 6;
            case Direction.EAST -> sidesConfig & 0xFCF | value << 4;
            case Direction.SOUTH -> sidesConfig & 0xFF3 | value << 2;
            case Direction.WEST -> sidesConfig & 0xFFC | value;
        };
    }

    public void dropItems(double pX, double pY, double pZ) {
        if (this.f_58857_ != null) {
            Containers.m_18992_((Level)this.f_58857_, (double)pX, (double)pY, (double)pZ, (ItemStack)this.getItemInSlot(this.baseSlotsLazy, 0));
            Containers.m_18992_((Level)this.f_58857_, (double)pX, (double)pY, (double)pZ, (ItemStack)this.getItemInSlot(this.additionSlotsLazy, 0));
            Containers.m_18992_((Level)this.f_58857_, (double)pX, (double)pY, (double)pZ, (ItemStack)this.getItemInSlot(this.outputSlotsLazy, 0));
        }
    }

    public void update() {
        this.requestModelDataUpdate();
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_46597_(this.f_58858_, this.m_58900_());
        }
    }

    private ContainerData getData() {
        return new ContainerData(){

            public int m_6413_(int index) {
                return switch (index) {
                    case 0 -> AutoSmithingTableBlockEntity.this.FEStored >> 16;
                    case 1 -> AutoSmithingTableBlockEntity.this.FEStored & 0xFFFF;
                    case 2 -> AutoSmithingTableBlockEntity.this.progress;
                    case 3 -> AutoSmithingTableBlockEntity.this.sidesConfig;
                    default -> 0;
                };
            }

            public void m_8050_(int index, int value) {
                switch (index) {
                    case 2: {
                        AutoSmithingTableBlockEntity.this.progress = value;
                        break;
                    }
                    case 3: {
                        AutoSmithingTableBlockEntity.this.sidesConfig = value;
                    }
                }
            }

            public int m_6499_() {
                return 4;
            }
        };
    }

    public ItemStack getItemInSlot(LazyOptional<ItemStackHandler> slotsLazy, int slot) {
        return slotsLazy.map(inv -> inv.getStackInSlot(slot)).orElse(ItemStack.f_41583_);
    }

    public ItemStack insertItem(LazyOptional<ItemStackHandler> slotsLazy, int slot, ItemStack stack) {
        this.requiresUpdate = true;
        if (slotsLazy == this.outputSlotsLazy) {
            this.canInsertOutput = true;
            ItemStack result = slotsLazy.map(inv -> inv.insertItem(slot, stack, false)).orElse(ItemStack.f_41583_);
            this.canInsertOutput = false;
            return result;
        }
        return slotsLazy.map(inv -> inv.insertItem(slot, stack, false)).orElse(ItemStack.f_41583_);
    }

    private ItemStackHandler createOutputInventory() {
        return new ItemStackHandler(1){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!simulate) {
                    AutoSmithingTableBlockEntity.this.update();
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (AutoSmithingTableBlockEntity.this.canInsertOutput) {
                    if (!simulate) {
                        AutoSmithingTableBlockEntity.this.requiresUpdate = true;
                    }
                    return super.insertItem(slot, stack, simulate);
                }
                return stack;
            }
        };
    }

    private ItemStackHandler createInventory() {
        return new ItemStackHandler(1){

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (!simulate) {
                    AutoSmithingTableBlockEntity.this.update();
                }
                return super.extractItem(slot, amount, simulate);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (!simulate) {
                    AutoSmithingTableBlockEntity.this.requiresUpdate = true;
                }
                return super.insertItem(slot, stack, simulate);
            }

            protected void onContentsChanged(int slot) {
                UpgradeRecipe upgradeRecipe = AutoSmithingTableBlockEntity.this.currentRecipe = AutoSmithingTableBlockEntity.this.f_58857_ == null ? null : AutoSmithingTableBlockEntity.this.getRecipeFromStacks(AutoSmithingTableBlockEntity.this.getItemInSlot(AutoSmithingTableBlockEntity.this.baseSlotsLazy, 0), AutoSmithingTableBlockEntity.this.getItemInSlot(AutoSmithingTableBlockEntity.this.additionSlotsLazy, 0));
                if (AutoSmithingTableBlockEntity.this.currentRecipe == null && AutoSmithingTableBlockEntity.this.progress > 0) {
                    AutoSmithingTableBlockEntity.this.progress = 0;
                }
            }
        };
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int toReceive = Math.min((Integer)ASTConfig.COMMON.maxEnergyStored.get() - this.FEStored, maxReceive);
        if (!simulate) {
            this.FEStored += toReceive;
            this.requestModelDataUpdate();
        }
        return toReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.FEStored;
    }

    public int getMaxEnergyStored() {
        return (Integer)ASTConfig.COMMON.maxEnergyStored.get();
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.FEStored < (Integer)ASTConfig.COMMON.maxEnergyStored.get();
    }
}

